/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;

public class TopGearRandomizer {
    public static int listSize;
    public static ArrayList<String> topGearTitles;
    static String backupFile;
    static boolean doBackup;
    static BufferedReader in;
    static BufferedWriter out;

    static {
        backupFile = "topGear.html";
    }

    public static void main(String[] args) {
        topGearTitles = new ArrayList();
        String topGearLine = new String();
        int count = 0;
        try {
            URL wiki = new URL("http://en.wikipedia.org/wiki/List_of_Top_Gear_episodes");
            in = new BufferedReader(new InputStreamReader(wiki.openStream()));
            doBackup = true;
        }
        catch (IOException e) {
            try {
                System.out.println("URL could not be reached, reading from backup...");
                in = new BufferedReader(new FileReader(backupFile));
                doBackup = false;
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
        }
        String line = new String();
        try {
            if (doBackup) {
                out = new BufferedWriter(new FileWriter(backupFile));
            }
            while ((line = in.readLine()) != null) {
                String noHTMLLine;
                String noCitationLine;
                if (doBackup) {
                    out.write(line);
                    out.newLine();
                }
                if ((noCitationLine = (noHTMLLine = line.replaceAll("\\<.*?>", "")).replaceAll("\\[.*?]", "")).length() <= 0) continue;
                if (noCitationLine.startsWith("\"")) {
                    topGearLine = noCitationLine;
                    count = 4;
                    continue;
                }
                if (count == 1) {
                    String cleanLine = noCitationLine.replaceAll("&.*", "");
                    topGearLine = String.valueOf(topGearLine) + "\n" + cleanLine;
                    topGearTitles.add(topGearLine);
                    --count;
                    continue;
                }
                if (count == 0) continue;
                topGearLine = String.valueOf(topGearLine) + "\n" + noCitationLine;
                --count;
            }
            if (doBackup) {
                out.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        listSize = topGearTitles.size();
        String selectedTitle = TopGearRandomizer.getRandTitle();
        System.out.println("---------- Top Gear Randomizer ----------\n");
        System.out.println(String.valueOf(selectedTitle) + "\n");
        if (args.length == 0 || args[0].toLowerCase() != "cli") {
            new TopWindowFrame(selectedTitle);
        }
    }

    public static String getRandTitle() {
        int rand = (int)Math.floor(Math.random() * (double)listSize);
        String selectedTitle = topGearTitles.get(rand);
        return selectedTitle;
    }
}

